/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import intrinsic.Function;
import intrinsic.flash.display.DisplayObjectContainer;
import intrinsic.flash.events.MouseEvent;
import intrinsic.mx.containers.HBox;
import intrinsic.mx.containers.TitleWindow;
import intrinsic.mx.containers.VBox;
import intrinsic.mx.controls.ColorPicker;
import intrinsic.mx.events.CloseEvent;
import intrinsic.mx.managers.PopUpManager;
import intrinsic.mx.managers.PopUpManagerChildList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;

public class ColorDialog extends Dialog {
	RGB rgb;
	TitleWindow window;
	ColorPicker picker;

public ColorDialog (Shell parent) {
	this (parent, SWT.PRIMARY_MODAL);
}

public ColorDialog (Shell parent, int style) {
	super (parent, style);
	checkSubclass ();
}

void close () {
	PopUpManager.removePopUp(window);
	window = null;
	picker = null;
	//TODO send event
	System.out.println(rgb);
}

public RGB getRGB () {
	return rgb;
}

void handleOk(MouseEvent event) {
	if (picker != null) {
		int color = picker.selectedColor;
		rgb = new RGB((color >> 16) & 0xFF, (color >> 8) & 0xFF, color & 0xFF);
	}
	close();
}

native Function handleOkFunction ()/*{
	return handleOk__Lflash_events_MouseEvent_2;
}*/;

void handleCancel(MouseEvent event) {
	close();
}

native Function handleCancelFunction ()/*{
	return handleCancel__Lflash_events_MouseEvent_2;
}*/;

void handleClose(CloseEvent event) {
	close();
}

native Function handleCloseFunction ()/*{
	return handleClose__Lmx_events_CloseEvent_2;
}*/;

public RGB open () {
	window = new TitleWindow();
	window.showCloseButton = true;
	window.addEventListener (CloseEvent.CLOSE, handleCloseFunction ());
	if (title != null) window.title = title;
	VBox vbox = new VBox();
	vbox.setStyle("verticalGap", 10);
	vbox.setStyle("horizontalAlign", "center");
	window.addChild(vbox);
	HBox hbox1 = new HBox();
	hbox1.setStyle("paddingLeft", 20);
	hbox1.setStyle("paddingTop", 20);
	hbox1.setStyle("paddingBottom", 20);
	hbox1.setStyle("paddingRight", 20);
	vbox.addChild(hbox1);
	intrinsic.mx.controls.Label label = new intrinsic.mx.controls.Label();	
	label.text = SWT.getMessage("SWT_Color");
	hbox1.addChild(label);
	picker = new ColorPicker();
	picker.width = 150;
	if (rgb != null) {
		picker.selectedColor = ((rgb.red & 0xFF) << 16) | ((rgb.green & 0xFF) << 8) | (rgb.blue & 0xFF);
	}
	rgb = null;
	hbox1.addChild(picker);
	HBox hbox2 = new HBox();
	hbox2.setStyle("horizontalAlign", "center");
	vbox.addChild(hbox2);
	intrinsic.mx.controls.Button ok = new intrinsic.mx.controls.Button();
	ok.label = SWT.getMessage("SWT_OK");
	ok.addEventListener (MouseEvent.CLICK, handleOkFunction ());
	hbox2.addChild(ok);
	intrinsic.mx.controls.Button cancel = new intrinsic.mx.controls.Button();
	cancel.label = SWT.getMessage("SWT_Cancel");
	cancel.addEventListener (MouseEvent.CLICK, handleCancelFunction ());
	hbox2.addChild(cancel);
	ok.validateProperties();
	ok.validateSize();
	cancel.validateProperties();
	cancel.validateSize();
	ok.width = cancel.width = Math.max(ok.measuredWidth, cancel.measuredWidth);
	window.defaultButton = ok;
	DisplayObjectContainer sprite = parent != null ? parent.parentingComponent() : null;
	PopUpManager.addPopUp(window, sprite, true, PopUpManagerChildList.APPLICATION);
	PopUpManager.centerPopUp(window);
	return rgb;
}

public void setRGB (RGB rgb) {
	this.rgb = rgb;
}

}
